//Librairie pour afficheur LCD 16*1 charactres
//Rvision du 01/06/2005
//N.B. Le LCD 16*1 est en fait deux LCDs 8*1 sur la mme ligne
//c'est pourquoi on doit choisir entre ligne 1 et 2 (chaque  cran)
//Librairie pour afficheur LCD 16*1 charactres
//Rvision du 01/06/2005
//N.B. Le LCD 16*1 est en fait deux LCDs 8*1 sur la mme ligne
//c'est pourquoi on doit choisir entre ligne 1 et 2 (chaque  cran)
/*
Dfinitions des pins pour le LCD
 ajuster selon l'application
LCD => PIC
-----------
14 => RD7
13 => RD6
12 => RD5
11 => RD4
10 => RD3
9 => RD2
8 => RD1
7 => RD0
6 => RC4 (En)
5 => RC5 (RW)
4 => RC3 (RS)
3 => x (contraste)
2 => x (GND)
1 => x (5V)
*/
#define LCDdata          PORTD
#define TRIS_LCDdata     TRISD
#define LCDenable        PORTCbits.RC4
#define TRIS_LCDenable   TRISCbits.TRISC4
#define LCDrs            PORTCbits.RC3
#define TRIS_LCDrs       TRISCbits.TRISC3
#define LCDrw            PORTCbits.RC5
#define TRIS_LCDrw       TRISCbits.TRISC5
//Defines pour config du lcd
#define clear 1
#define home 2
#define cursorON 3
#define cursorOFF 4
#define shift 5
//Dlais
#define wait Delay10KTCYx(1)
#define longwait Delay10KTCYx(15)



#define shortwait Delay1KTCYx(1)
#define Delay_05ms Delay10TCYx(250)
//variables utilises ds les routines
int t;
int o;
//fonction d'initialisation de l'cran
void initlcd (void)
{
LCDdata = 0b00000000; //toutes les pins de donnes  0
LCDrw = 0;
LCDenable = 0; //enable  0
LCDrs = 0; //Register Select  0 (configuration)
longwait;
//display ON
LCDdata = 0b00001111;
wait;
LCDenable = 1;
wait;
LCDenable = 0;
wait;
// mode 8 bit
LCDdata = 0b00000001;
wait;
LCDenable = 1;
wait;
LCDenable = 0;
wait;
// effacer l'cran
LCDdata = 0b00111000;
wait;
LCDenable = 1;
wait;
LCDenable = 0;
wait;
}
//fonction pour choisir entre quelle ligne d'cran
void line (int x)
{
if (x == 1)
{
//set display adress au dbut de l'cran (ligne 1)
LCDrs = 0;
LCDrw = 0;
LCDdata = 0x80;
wait;



LCDenable = 1;
wait;
LCDenable = 0;
wait;
}
if (x == 2)
{
//set display adress au 9e charactre (ligne 2)
LCDrs = 0;
LCDrw = 0;
LCDdata = 0xC0;
wait;
LCDenable = 1;
wait;
LCDenable = 0;
wait;
}
}
//configuration de l'cran (efface, home, etc)

void configlcd (int config)
{

if (config == clear)
   {
//efface l'cran
LCDrs = 0;
LCDdata = 0b00000001;
shortwait;
LCDenable = 1;
shortwait;
LCDenable = 0;
wait;
   }

if (config == home)
   {
//curseur et cran home
LCDrs = 0;
LCDdata = 0b00000011;
wait;
LCDenable = 1;
wait;
LCDenable = 0;
wait;
   }

if (config == cursorON)
   {
//curseur ON
LCDrs = 0;
LCDdata = 0b00001111;

wait;
LCDenable = 1;
wait;
LCDenable = 0;
wait;
   }

if (config == cursorOFF)
  {
//curseur OFF
LCDrs = 0;
LCDdata = 0b00001100;
wait;
LCDenable = 1;
wait;
LCDenable = 0;
wait;
  }
if (config == shift)
  {
//shift display
LCDrs = 0;
LCDdata = 0b00011000;
wait;
LCDenable = 1;
wait;
LCDenable = 0;
wait;
  }


}
//affichage d'un charactre sur l'cran
void printlcd (char text)
{
LCDrs = 1;
shortwait;
LCDdata = text; // print text
shortwait;
LCDenable = 1;
shortwait;
LCDenable = 0;
LCDdata = 0b00000000; //remet toutes les sorties  0
LCDrs = 0;
}


//affichage d'une chaine de charactres sur l'cran
void printstringlcd (char *str)
{

line(1);
for(t=0; t<=7; ++t) //imprime les premiers charactres
   {
     printlcd(str[t]);
   }

line(2);
for(t=8; t<=15; ++t) //imprime les derniers charactres
    {
      printlcd(str[t]);
    }
}
